/*
 * Decompiled with CFR 0.152.
 */
package sojamo.drop;

import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import javax.swing.ImageIcon;
import processing.core.PApplet;
import processing.core.PImage;
import sojamo.drop.DropEvent;

public class DropImageReader
implements Runnable {
    private final DropEvent _myDropEvent;
    private Thread _myThread;
    protected static final int LOAD_IMAGE_FROM_URL = 0;
    protected static final int LOAD_IMAGE_FROM_DISK = 1;
    private PImage _myImage;
    private String _myPath;

    protected DropImageReader(DropEvent dropEvent) {
        this._myDropEvent = dropEvent;
        this.start();
    }

    protected DropImageReader(DropEvent dropEvent, PImage pImage, String string) {
        this._myDropEvent = dropEvent;
        this._myImage = pImage;
        this._myPath = string;
        this.start();
    }

    public void start() {
        this._myThread = new Thread(this);
        this._myThread.start();
    }

    protected Image loadImage(Image image) {
        MediaTracker mediaTracker = new MediaTracker(this._myDropEvent.drop.parent);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            System.out.println("### ERROR " + interruptedException);
        }
        catch (Exception exception) {
            System.out.println("### ERROR at loadImage " + exception);
        }
        return image;
    }

    private void updatePImage(PImage pImage) {
        if (pImage.width > 0 && pImage.height > 0) {
            this._myImage.init(pImage.width, pImage.height, pImage.format);
            this._myImage.loadPixels();
            this._myImage.pixels = pImage.pixels;
            this._myImage.updatePixels();
        } else {
            System.out.println("### ERROR sojamo.drop. unable to load image from " + this._myPath);
        }
    }

    public void run() {
        try {
            if (this._myDropEvent.drop.parent instanceof PApplet) {
                PImage pImage = ((PApplet)this._myDropEvent.drop.parent).loadImage(this._myPath);
                this.updatePImage(pImage);
            }
            this.stop();
            return;
        }
        catch (Exception exception) {
            this.stop();
            return;
        }
    }

    public void stop() {
        this._myThread = null;
    }

    public void dispose() {
        this.stop();
    }

    public static boolean hasAlpha(Image image) {
        if (image instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)image;
            return bufferedImage.getColorModel().hasAlpha();
        }
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ColorModel colorModel = pixelGrabber.getColorModel();
        return colorModel.hasAlpha();
    }

    public static BufferedImage scaleImage(BufferedImage bufferedImage, float f, float f2) {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.scale(f, f2);
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 2);
        BufferedImage bufferedImage2 = affineTransformOp.filter(bufferedImage, null);
        return bufferedImage2;
    }

    public static BufferedImage ConvertToBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        boolean bl = DropImageReader.hasAlpha(image);
        BufferedImage bufferedImage = null;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            int n = 1;
            if (bl) {
                n = 2;
            }
            GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
            GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
            bufferedImage = graphicsConfiguration.createCompatibleImage(image.getWidth(null), image.getHeight(null), n);
        }
        catch (HeadlessException headlessException) {
            // empty catch block
        }
        if (bufferedImage == null) {
            int n = 1;
            if (bl) {
                n = 2;
            }
            bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), n);
        }
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage;
    }
}

